MODULE mKFM
use mGlobalData
use m3D_FFVM_RE
use m1D_FFVM_DWE
implicit none

    CONTAINS    

!___________________________________________________________!
!  Solve Flow problem in 3-D matrix, 1-D conduit or karst domain (conduit+matrix)    
    subroutine SolveFlowProblem
    
        open(lunFScreen,file=ScreenRecordFile)
        
        !Karst flow problem - coupled 3D matrix and 1D conduit
        IF(MATRIX3D.and.CONDUIT1D) THEN
            

            !Initialize matrix solver
            call InitializeRE3D
          
            !Initialize conduit solver
            call InitializeDW1D
            
            !Find matrix steady state solution
            !call ModifyBCDataDW1D('ConduitClosed')
            call CalculateMatrixSteadyState
            !call ModifyBCDataDW1D('ConduitOpened')
            
            !!Find conduit steady state solution
            !call CalculateConduitSteadyState
            
            !Create input data file
            call CreateCalcInputParamFileKFM
            
            iterKFM=0
			
            !MaxIterStartKFM=MaxIterKFM
            
            call ScreenRecord('Start')
            call WriteResults('InitializeHydrographs')
            
            ProceedToNextTimeStep=.true.
            
            !ITERATIVE COUPLING OF KARST FLOW MODEL
            !Time-marching loop
            do while(TimeCurr.lt.TimeEnd-eps_small)
                if(ProceedToNextTimeStep) icntTimeStep=icntTimeStep+1
                epsCurrKFM=1.d+9
                iterKFM=0
                !MaxIterKFM=MaxIterStartKFM
                call ScreenRecord('Time')
                !Read input data - for changing parameters during calaculation
                call ReadCalcInputParametersKFM
                !Non-linear iteration loop
                do while(epsCurrKFM.gt.epsNonLinKFM)
                    !!Read input data - for changing parameters during calaculation
                    !call ReadCalcInputParametersKFM
                    iterKFM=iterKFM+sup1
                    call ScreenRecord('Iter')
                    epsCurrKFM=0.d0
                    call SolveRE3D(TimeCurr+TimeStep)
                    call SolveDW1D(TimeCurr+TimeStep)
                    !If maximum number of iterations has been reached
                    !if(iterKFM.ge.MaxIterKFM) call MaxIterationReachedManualControl
                    if(iterKFM.ge.MaxIterKFM) exit
                enddo
                !Correct time step based on number of iterKFM
                call AdaptiveTimeStepControl(iterKFM,ProceedToNextTimeStep)

				if(ProceedToNextTimeStep) then
                    TimeCurr=TimeCurr+TimeStep
                    call UpdateCoeffRE3D('TimeStepEnd')
                    call UpdateCoeffDW1D('TimeStepEnd')
                    call ResultsRE3D
                    call ResultsDW1D
                    call WriteResults('Hydrographs')
                    call ChangeExperimentalSetup
                endif
            enddo            
            
        !Groundwater flow problem - only 3D matrix
        ELSEIF(MATRIX3D) THEN
            
            call InitializeRE3D
            call CalculateMatrixSteadyState
            
            call WriteResults('InitializeHydrographs')
            do while(TimeCurr.lt.TimeEnd-eps_small)
                icntTimeStep=icntTimeStep+1
                call SolveRE3D(TimeCurr+TimeStep)
                TimeCurr=TimeCurr+TimeStep
                call UpdateCoeffRE3D('TimeStepEnd')
                call ResultsRE3D
                call WriteResults('Hydrographs')
                call ChangeExperimentalSetup
            enddo
            
        !Conduit flow problem - only 1D conduit
        ELSEIF(CONDUIT1D) THEN
            
            call InitializeDW1D
            call WriteResults('InitializeHydrographs')
            do while(TimeCurr.lt.TimeEnd-eps_small)
                icntTimeStep=icntTimeStep+1
                call SolveDW1D(TimeCurr+TimeStep)
                TimeCurr=TimeCurr+TimeStep
                call UpdateCoeffDW1D('TimeStepEnd')
                call ResultsDW1D
                call WriteResults('Hydrographs')
            enddo            
        ENDIF
        
        call CPU_TIME(CpuTime)
        call ScreenRecord('End')
     
    
    end subroutine
    
!___________________________________________________________!
!  Solve uncoupled Flow and Transport problem in 3-D matrix, 1-D conduit 
!  or karst domain (conduit+matrix), usually for salt or heat tracer tests or
!  conservative contamination problem  

  
    subroutine SolveFlowandTransportProblem
    
        open(lunFScreen,file=ScreenRecordFile)
        
        !Karst flow problem - coupled 3D matrix and 1D conduit
        IF(MATRIX3D.and.CONDUIT1D) THEN
            

            !Initialize matrix solver
            call InitializeRE3D
          
            !Initialize conduit solver
            call InitializeDW1D
            
            !Find matrix steady state solution
            !call ModifyBCDataDW1D('ConduitClosed')
            call CalculateMatrixSteadyState
            !call ModifyBCDataDW1D('ConduitOpened')
            
            !!Find conduit steady state solution
            !call CalculateConduitSteadyState
            
            !Create input data file
            call CreateCalcInputParamFileKFM
            
            iterKFM=0
			iterTransport=0
			
            !MaxIterStartKFM=MaxIterKFM
            
            call ScreenRecord('Start')
            call WriteResults('InitializeHydrographs')
            
            ProceedToNextTimeStep=.true.
            
            !ITERATIVE COUPLING OF KARST FLOW MODEL
            !Time-marching loop
            do while(TimeCurr.lt.TimeEnd-eps_small)
                if(ProceedToNextTimeStep) icntTimeStep=icntTimeStep+1
                epsCurrKFM=1.d+9
                epsCurrTransport=1.d+9
				iterKFM=0
                !MaxIterKFM=MaxIterStartKFM
                call ScreenRecord('Time')
                !Read input data - for changing parameters during calaculation
                call ReadCalcInputParametersKFM
                !Non-linear iteration loop
                do while(epsCurrKFM.gt.epsNonLinKFM)
                    !!Read input data - for changing parameters during calaculation
                    !call ReadCalcInputParametersKFM
                    iterKFM=iterKFM+sup1
                    call ScreenRecord('Iter')
                    epsCurrKFM=0.d0
                    call SolveRE3D(TimeCurr+TimeStep)
                    call SolveDW1D(TimeCurr+TimeStep)
                    !If maximum number of iterations has been reached
                    !if(iterKFM.ge.MaxIterKFM) call MaxIterationReachedManualControl
                    if(iterKFM.ge.MaxIterKFM) exit
                enddo
                !Correct time step based on number of iterKFM
                call AdaptiveTimeStepControl(iterKFM,ProceedToNextTimeStep)
 !!!  Solve Transport problem in the current time step
                if(ProceedToNextTimeStep) then
                    call SolveAdvection3D(TimeCurr+TimeStep)
                    call SolveAdvection1D(TimeCurr+TimeStep)
					epsCurrTransport=0.0d0
               do while(epsCurrTransport.gt.epsNonLinKFM)
                    !!Read input data - for changing parameters during calaculation
                    !call ReadCalcInputParameters
					iterTransport=iterTransport+sup1
                    call ScreenRecord('Iter')
                    epsCurrTransport=0.0d0
                    call SolveDispersion3D(TimeCurr+TimeStep)
                    call SolveDispersion1D(TimeCurr+TimeStep)
                    !If maximum number of iterations has been reached
                    !if(iterKFM.ge.MaxIterKFM) call MaxIterationReachedManualControl
                    if(iterTransport.ge.MaxIterKFM) exit
                enddo
				end if
				if(ProceedToNextTimeStep) then
                    TimeCurr=TimeCurr+TimeStep
                    call UpdateCoeffRE3D('TimeStepEnd')
                    call UpdateCoeffDW1D('TimeStepEnd')
                    call ResultsRE3D
                    call ResultsDW1D
                    call ResultsTransport3D
                    call ResultsTransport1D
                    call WriteResults('Hydrographs')
                    call ChangeExperimentalSetup
                endif
            enddo            
            
        !Groundwater flow problem - only 3D matrix
        ELSEIF(MATRIX3D) THEN
            
            call InitializeRE3D
            call CalculateMatrixSteadyState
            
            call WriteResults('InitializeHydrographs')
            do while(TimeCurr.lt.TimeEnd-eps_small)
                icntTimeStep=icntTimeStep+1
                call SolveRE3D(TimeCurr+TimeStep)
                TimeCurr=TimeCurr+TimeStep
                call UpdateCoeffRE3D('TimeStepEnd')
                call ResultsRE3D
                call WriteResults('Hydrographs')
                call ChangeExperimentalSetup
            enddo
            
        !Conduit flow problem - only 1D conduit
        ELSEIF(CONDUIT1D) THEN
            
            call InitializeDW1D
            call WriteResults('InitializeHydrographs')
            do while(TimeCurr.lt.TimeEnd-eps_small)
                icntTimeStep=icntTimeStep+1
                call SolveDW1D(TimeCurr+TimeStep)
                TimeCurr=TimeCurr+TimeStep
                call UpdateCoeffDW1D('TimeStepEnd')
                call ResultsDW1D
                call WriteResults('Hydrographs')
            enddo            
        ENDIF
        
        call CPU_TIME(CpuTime)
        call ScreenRecord('End')
     
    
    end subroutine
	
	
        subroutine CreateCalcInputParamFileKFM

        open(lunF1,file='InputKFM.inp')
        write(lunF1,*) 'MaxIterKFM',MaxIterKFM
        write(lunF1,*) 'MinIterKFM',MinIterKFM
        write(lunF1,*) 'epsNonLinKFM',epsNonLinKFM
        write(lunF1,*) 'TimeEnd',TimeEnd
        write(lunF1,*) 'TimeStep',TimeStep
        write(lunF1,*) 'dt3D',dt3D
        write(lunF1,*) 'dt1D',dt1D
        write(lunF1,*) 'MinTimeStep',MinTimeStep
        write(lunF1,*) 'MaxTimeStep',MaxTimeStep
        write(lunF1,*) 'nWriteResults',nWriteResults
        write(lunF1,*) 'kMaxEx',kMaxEx
        close(lunF1)

    end subroutine
    
    subroutine ReadCalcInputParametersKFM
    
        character(len=40) ch,CSwitch
    
        !Control switch
        open(lunF1,file='CSwitchKFM.inp')
        read(lunF1,*) CSwitch
        close(lunF1)
        if(CSwitch.eq.'no') return
        
        write(*,*) 'Change parameters and press enter to continue.'
        write(lunFScreen,*) 'Change parameters and press enter to continue.'
        read(*,*)
        
        !Read parameters values
        open(lunF1,file='InputKFM.inp')
        read(lunF1,*) ch,MaxIterKFM
        read(lunF1,*) ch,MinIterKFM
        read(lunF1,*) ch,epsNonLinKFM
        read(lunF1,*) ch,TimeEnd
        read(lunF1,*) ch,TimeStep
        read(lunF1,*) ch,dt3D
        read(lunF1,*) ch,dt1D
        read(lunF1,*) ch,MinTimeStep
        read(lunF1,*) ch,MaxTimeStep
        read(lunF1,*) ch,nWriteResults
        read(lunF1,*) ch,kMaxEx
        close(lunF1)
        
        !Return CSwitch to 'no'
        open(lunF1,file='CSwitchKFM.inp')
        write(lunF1,*) 'no'
        close(lunF1)        
        
    
    end subroutine
            
    subroutine CalculateMatrixSteadyState
    
        integer (kind=4) maxiter3DTemp
        real (kind=8) dt3DTemp
        
        SteadyStateKFM=.true.
        dt3DTemp=dt3D
        dt3D=1.d+20
        maxiter3DTemp=maxiter3D
        maxiter3D=maxiter3D_SS
        call SolveRE3D(TimeCurr+dt3D)
        call ResultsRE3D
        dt3D=dt3DTemp
        maxiter3D=maxiter3DTemp
        SteadyStateKFM=.false.
        call UpdateCoeffRE3D('TimeStepEnd')
            
    end subroutine
        
    subroutine CalculateConduitSteadyState
    
        integer (kind=4) maxiter1DTemp
        real (kind=8) dt1DTemp
        
        SteadyStateKFM=.true.
        dt1DTemp=dt1D
        dt1D=1.d+20
        maxiter1DTemp=maxiter1D
        maxiter1D=maxiter1D_SS
        call SolveDW1D(TimeCurr+dt1D)
        call ResultsDW1D
        dt1D=dt1DTemp
        maxiter1D=maxiter1DTemp
        SteadyStateKFM=.false.
        call UpdateCoeffDW1D('TimeStepEnd')
            
    end subroutine
                
    subroutine ChangeExperimentalSetup
    
        !!Open conduit
        !!if(abs(TimeCurr-10.d0*60.d0).lt.TimeStep) call UpdateInputDataDW1D
        !!Rain start
        !if(abs(TimeCurr-(30.d0*60.d0)).lt.eps_small) FluxRelaxation3D=1.d0
        !!Rain end
        !if(abs(TimeCurr-(120.d0*60.d0)).lt.eps_small) FluxRelaxation3D=0.d0
        
        
        if(TestCase.eq.'C2') then
            if(abs(TimeCurr-3000.d0).lt.eps_small) then
                TimeStep=1.0d0*60.d0
                !maxiter3D=18
                !MaxIterKFM=3
                !nWriteResults=1 !!!***!!!
                !!EUR3D=0.1d0
                call CreateCalcInputParamFileKFM
            endif
        endif
         
    
    end subroutine
                   
    subroutine AdaptiveTimeStepControl(iter,proceed)
    
        integer (kind=4) iter
        logical proceed
        
        proceed=.true.
    
        !Decrease time step
        if(iter.ge.MaxIterKFM) then
            if(epsCurrKFM.le.epsNonLinKFM) return
            if(abs(TimeStep-MinTimeStep).lt.eps_small) return
            TimeStep=0.5d0*TimeStep
            TimeStep=max(TimeStep,MinTimeStep)
            call UpdateCoeffRE3D('TimeStepRestart')
            call UpdateCoeffDW1D('TimeStepRestart')
            call CreateCalcInputParamFileKFM
            proceed=.false.
        endif
        !!Increase time step
        !if(iter.lt.MinIterKFM) then
        !    TimeStep=2.0d0*TimeStep
        !    TimeStep=min(TimeStep,MaxTimeStep)
        !    call CreateCalcInputParamFileKFM
        !endif
        
    
    end subroutine
                       
    subroutine MaxIterationReachedManualControl
    
        if(CorrectMaxIter.eq.'no') return
        
        write(*,'(/,a)') 'Enter number of additional iteration.'
        write(*,'(a)') ' 0 - Go to next time step.'
        write(*,'(a)') '-1 - Write current results.'
        write(*,'(a)') '-2 - ABORT.'
        read(*,*) AddIter
        if(AddIter.eq.-1) then
            call ResultsRE3D
            call ResultsDW1D
            write(*,'(/,a)') 'File created. Enter number of additional iteration.'
            read(*,*) AddIter
        endif
        if(AddIter.eq.-2) stop          
        !Change maximum number of iteration
        MaxIterKFM=MaxIterKFM+AddIter        
    
    end subroutine
           
    subroutine ScreenRecord(sc)
    
        character(*) sc
                
        SELECT CASE(sc)

        CASE('Start')
            write(*,'(1xa)') 'KARST PARAMETERS'
            write(*,'(1xa,e20.10)') 'epsKFM',epsNonLinKFM
            write(*,'(1xa,i4,/)') 'MaxIterKFM',MaxIterKFM
            write(*,'(a,/)') 'START OF CALCULATION'
            
            write(lunFScreen,'(1xa)') 'KARST PARAMETERS'
            write(lunFScreen,'(1xa,e20.10)') 'epsKFM',epsNonLinKFM
            write(lunFScreen,'(1xa,i4,/)') 'MaxIterKFM',MaxIterKFM
            write(lunFScreen,'(a,/)') 'START OF CALCULATION'
            
        CASE('Time')
            write(*,'(a,/)') '========================================================================================'
            write(*,'(a,e20.10,8xa,i6)') 'CURRENT TIME:',(TimeCurr+TimeStep)*TimeUnitConvert,'Time Step:',icntTimeStep

            write(lunFScreen,'(a,/)') '========================================================================================'
            write(lunFScreen,'(a,e20.10,8xa,i6)') 'CURRENT TIME:',(TimeCurr+TimeStep)*TimeUnitConvert,'Time Step:',icntTimeStep
            
        CASE('Iter')
            write(*,'(a)') '____________________________________________'
            if(iterKFM.eq.sup1) then
                write(*,'(a,i4,4xa,4xa,/)') 'ITERATION:',iterKFM,'epsKFM','-'
            else
                write(*,'(a,i4,4xa,e20.10,/)') 'ITERATION:',iterKFM,'epsKFM',epsCurrKFM
            endif

            write(*,'(a)') '____________________________________________'
            if(iterKFM.eq.sup1) then
                write(lunFScreen,'(a,i4,4xa,4xa,/)') 'ITERATION:',iterKFM,'epsKFM','-'
            else
                write(lunFScreen,'(a,i4,4xa,e20.10,/)') 'ITERATION:',iterKFM,'epsKFM',epsCurrKFM
            endif
            
        CASE('End')
            write(*,'(a,/)') '============================================'
            write(*,'(/,a)') 'CALCULATION FINISED.'
            write(*,'(a,f20.8)') 'CPU time:', CpuTime
            
            write(lunFScreen,'(a,/)') '============================================'
            write(lunFScreen,'(/,a)') 'CALCULATION FINISED.'
            write(lunFScreen,'(a,f20.8)') 'CPU time:', CpuTime
            
        END SELECT
                
    
    end subroutine
           
    subroutine WriteResults(sc)
    
        character(*) sc
        integer (kind=4) iterCount
        real (kind=8) t, QmIn, QmOut, QcIn, QcOut, QmRain, QcSinkhole
        
        SELECT CASE(sc)

        CASE('InitializeHydrographs')
            QmIn=QmatrixInlet*DischargeUnitConvert
            QmOut=QmatrixOutlet*DischargeUnitConvert
            QcIn=QconduitInlet*DischargeUnitConvert
            QcOut=QconduitOutlet*DischargeUnitConvert
            QmRain=Qrain*DischargeUnitConvert
            QcSinkhole=Qsinkhole*DischargeUnitConvert
            open(lunF1,file='Hydrographs.dat')
            write(lunF1,'(a)') 'TITLE = KFM_4.1_Hydrographs "'
            write(lunF1,'(a)')  'VARIABLES = "t", "QmIn", "QmOut", "QcIn", "QcOut", "QmRain", "QcSinkhole", "iterKFM", "epsCurrKFM" '
            write(lunF1,'(7e20.10,i7,e20.10)') (TimeCurr-10.d0*TimeStep)*TimeUnitConvert, QmIn, QmOut, QcIn, QcOut, QmRain, QcSinkhole,0,0.d0
            write(lunF1,'(7e20.10,i7,e20.10)') (TimeCurr)*TimeUnitConvert, QmIn, QmOut, QcIn, QcOut, QmRain, QcSinkhole,0,0.d0
            close(lunF1)
        CASE('Hydrographs') 
            t=TimeCurr*TimeUnitConvert
            QmIn=QmatrixInlet*DischargeUnitConvert
            QmOut=QmatrixOutlet*DischargeUnitConvert
            QcIn=QconduitInlet*DischargeUnitConvert
            QcOut=QconduitOutlet*DischargeUnitConvert
            QmRain=Qrain*DischargeUnitConvert
            QcSinkhole=Qsinkhole*DischargeUnitConvert
            if(MATRIX3D) iterCount=iterRE3D
            if(CONDUIT1D) iterCount=iterDW1D
            if(MATRIX3D.AND.CONDUIT1D) iterCount=iterKFM
            
            open(lunF1,file='Hydrographs.dat',status='old',position='append')   !,action='write'
            write(lunF1,'(7e20.10,i7,e20.10)') t, QmIn, QmOut, QcIn, QcOut, QmRain, QcSinkhole,iterCount,epsCurrKFM
            close(lunF1)
                        
        END SELECT
        
    
        end subroutine
                 
!___________________________________________________________!
    
END MODULE    
    
PROGRAM TEST_KFM_iter_4_1
use mGlobalData
use BASISFUNCTION
use mKFM
implicit none   

    !Read input data
    call InputData_KFM
    
    !Prepare basis functions
    call ReadBasisFunctionValues(BasisFun,nOrder)
    
    !Start calculation
    call SolveFlowProblem  
      
    
END PROGRAM

  
